#include <gst/gst.h>
#import "VideoStreamBackendDelegate.h"

@interface GStreamerBackend : NSObject
{
    GstElement *_pipeline;
    GMainContext *_context;
    GMainLoop *_mainLoop;
    BOOL _pipelineIsRunning;
    BOOL _isActive;
}

@property (weak, nonatomic, readonly) id delegate;
@property (nonatomic, strong, readonly) NSString* streamId;

// is processing/consuming incoming data
@property (nonatomic, readonly) BOOL isActive;

-(id) initWithDelegate:(id)delegate streamId:(NSString *)streamId;
-(void) start;
-(void) stop;

-(NSString *) getGStreamerVersion;

-(void) gstLeaveMainLoop;
-(void) gstElementMessage:(GstBus *)bus message:(GstMessage *)msg;
-(void) gstPipelineStateChanged:(GstState)oldState newState:(GstState)newState pendingState:(GstState)pendingState;

-(NSString *) buildPipeline;
-(void) pipelineStartRequestIssuedSuccessfully;
-(void) pipelineDidStart;
-(void) pipelineDidStop;
-(BOOL) objectIsPipeline:(GstObject *)object;

-(void) setMessage:(NSString *) message;
-(void) setActive:(BOOL)isActive;

@end